/* ============ */
/* tstprobs.c	*/
/* ============ */
/* ==================================================================== */
/*		    Main Progrram to Test CalcGapProbs			*/
/* ==================================================================== */
#include <math.h>
#include <defcodes.h>
#include <miscdefs.h>
#include <gapdefs.h>
#include <mconf.h>
#include <stdio.h>

#define	MAX_GAPS	100
void
main()
{
    AbortGracefully();			/* Make ^C Reasonable */

    while (main)
    {
	int	k, NumLens;
	double	HiLimit, LoLimit, GapProbs[MAX_GAPS], TotlProb;

	for (;;)
	{
	    GetInt("Enter Number of Gap Lengths at Issue [>= 2, <= 100]: ",
		&NumLens);
	    if (NumLens >= 2 && NumLens <= 100)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}

	for (;;)
	{
	    GetDbl("Enter Lower Limit of Gap at Issue [>=0,<1]: ",
		&LoLimit);
	    if (LoLimit >= 0 && LoLimit < 1)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}

	for (;;)
	{
	    char    Prompt[64];
	    sprintf(Prompt, "Enter Upper Limit of Gap at Issue "
			    "[> %g,<=1]: ", LoLimit);

	    GetDbl(Prompt, &HiLimit);

	    if (HiLimit > LoLimit && HiLimit <= 1)
	    {
		break;
	    }
	    fprintf(stderr, "Incorrect Entry\n");
	}
	CalcGapProbs(NumLens, LoLimit, HiLimit, GapProbs);

	TotlProb = 0;
	for (k = 0; k < NumLens; ++k)
	{
	    TotlProb += GapProbs[k];
	    fprintf(stderr, "GapProb[%3d] = %.12e\n", k, GapProbs[k]);
	}
	fprintf(stderr, "Total Prob   = %.12e\n\n", TotlProb);
    }
}
